// // // // // // // // // // // // // // // //
//
//	AsciiKette.h
//
//	erstellt 12.12.97 von Andreas Warnke
//	geändert 2.3.98 von Andreas Warnke
//
//	Dieses Modul stellt Funktionen zur Stringbearbeitung
//	zur Verfügung.
//
//	Die von diesem Modul bereitgestellten Funktionen
//	geben KEINE Strings, die als Argumente übergeben
//	werden frei, ABER sie reservieren Speicher für
//	die Funktionswerte.
//
//	Die Funktionen sind AUSSCHLIEßLICH für 1-Byte-Zeichen
//	geschrieben! Also KEINE Unicode-unterstützung!
//





#ifndef AsciiKette_H_
#define AsciiKette_H_



// // // // // // // // // // // // // // // //
//
//	IntToString
//	
//	konvertiert ein vorzeichenloses Integer
//	in einen nur aus (Hexa)Dezimalziffern bestehenden
//	C-String.
//

char* IntToString ( unsigned int inInt );
char* Int8ToHexString ( uint8 inInt8 );



// // // // // // // // // // // // // // // //
//
//	StringToInt
//	
//	konvertiert einen C-String in ein Integer.
//	Alle Zeichen außer Dezimalziffern werden
//	ignoriert. Ist keine Ziffer vorhanden, so
//	liefert StringToInt 0. Ist das Argument
//	ein NULL-Pointer, so liefert die Funktion
//	ebenfalls 0.
//

unsigned int StringToInt ( const char* inString );



// // // // // // // // // // // // // // // //
//
//	GetPos
//	
//	liefert die Position eines Musters in einem
//	String. Die Numerierung der Zeichen beginnt
//	mit 0. Ist eines der Funktionsargumente NULL,
//	oder das Muster nicht im String enthalten,
//	so liefert GetPos 0xfff..f .
//

unsigned int GetPos ( const char* inMuster, const char* inString, unsigned int inBeginAt = 0 );



// // // // // // // // // // // // // // // //
//
//	Length
//
//	Bestimmt die Länge eines Strings in Bytes.
//	Der 0-Terminator wird nicht mitgezählt. Ist
//	der übergebene String NULL, so wird 0 berechnet.
//	

unsigned int Length ( const char* inString );



// // // // // // // // // // // // // // // //
//
//	Concat
//	
//	Fügt die als Parameter übergebenen Strings
//	zusammen. Ist einer der Parameter NULL, so
//	wird er ignoriert. Sind alle Parameter null, 
//	so ist das Ergebis ein Zeiger auf ein 0-character.
//

char* Concat ( 
	const char* inString1,
	const char* inString2,
	const char* inString3 = NULL,
	const char* inString4 = NULL );



// // // // // // // // // // // // // // // //
//
//	ConcatAndDeleteEven/Odd
//	
//	Fügt die als Parameter übergebenen Strings
//	zusammen. Ist einer der Parameter NULL, so
//	wird er ignoriert. Sind alle Parameter null, 
//	so ist das Ergebis ein Zeiger auf ein 0-character.
//	Die als 2. und 4. bzw. 1. und 3. Parameter
//	übergebenen Strings werden mit delete[] gelöscht.
//

char* ConcatAndDeleteEven ( 
	const char* inString1,
	char* inString2,
	const char* inString3 = NULL,
	char* inString4 = NULL );
	
char* ConcatAndDeleteOdd ( 
	char* inString1,
	const char* inString2,
	char* inString3 = NULL,
	const char* inString4 = NULL );



// // // // // // // // // // // // // // // //
//
//	Equal
//	
//	Prüft, of die beiden übergebenen Strings
//	identisch sind. Sind einer oder beide Parameter
//	NULL, so liefert Equal false.

bool Equal ( const char* inString1, const char* inString2 );



#endif

//
//	The End
//
// // // // // // // // // // // // // // // //
